define(function () {

    var component = {
        props: ["hubnavigation"],
        data: function () {
            return {
                showEdit: false
            };
        },
        created: function () {
            var editButton = document.querySelector(".ms-HubNav div[data-automationid=HorizontalNav-edit] button");
            if (editButton)
                this.showEdit = true;
        },
        methods: {
            EditHubNavigation: function () {
                var editButton = document.querySelector(".ms-HubNav div[data-automationid=HorizontalNav-edit] button");
                if (editButton) {
                    editButton.click();
                    this.closeFoldouts();
                }
            }
        }
    };

    component.originalTemplate = "foldOutHub";
    component.template = `
<div data-v-a104ef70 class="foldout foldout-hub">
    <ul data-v-a104ef70 class="column-list">            
        <li data-v-a104ef70 class="column-listitem" v-for="column in hubnavigation.navigation" :key="column.Id" >    
            <div data-v-a104ef70 class="item-type item-type-heading">                    
                <a data-v-a104ef70 :href="column.Url">{{column.Title}}</a>
            </div>
            <ul data-v-a104ef70 class="item-list level1">
                <li data-v-a104ef70 class="item-listitem" v-for="item in column.Children" :key="item.Id">
                    <div data-v-a104ef70 class="item-type item-type-link">
                        <a data-v-a104ef70 :href="item.Url">{{item.Title}}</a>
                    </div>
                    <ul data-v-a104ef70 class="item-list level2">
                        <li data-v-a104ef70 class="item-listitem" v-for="subitem in item.Children" :key="subitem.Id">
                            <div data-v-a104ef70 class="item-type item-type-link">
                                <a data-v-a104ef70 :href="subitem.Url">{{subitem.Title}}</a>                            
                            </div>                        
                        </li>
                    </ul>                  
                </li>
            </ul>
        </li>
    </ul>
    <span data-v-a104ef70 class="edit" v-if="showEdit" @click="EditHubNavigation">Edit</span>
</div>
`;
    component.styles = `
.foldout[data-v-a104ef70] {
  cursor: initial;
  padding-top: 20px;
  padding-left: 30px;
  padding-right: 30px;
  padding-bottom: 20px;
  background-color: "[theme: bodyBackground, default: #ffffff]";
  color: "[theme: themeDarker, default: #282c2e]";
}
.column-list[data-v-a104ef70], .item-list[data-v-a104ef70] {
  margin: 0 0 0 0;
  padding: 0 0 0 0;
}
.column-listitem[data-v-a104ef70] {
  vertical-align: top;
  display: inline-block;
  margin-right: 47px;
}
.item-list[data-v-a104ef70] {
  line-height: 26px;
}
.item-listitem[data-v-a104ef70] {
  list-style: none;
}
.item-list.level2[data-v-a104ef70] {
  margin-left: 12px;
}
.item-type[data-v-a104ef70] {
  display: block;
  margin-bottom: 10px;
  font-size: 14px;
}
.item-type a[data-v-a104ef70] {
    color: inherit;
    text-decoration: none;
}
.item-type-heading[data-v-a104ef70] {
  font-weight: 600;
  text-transform: uppercase;
}
.edit[data-v-a104ef70] {
  cursor: pointer;
}

/* Hover effect removed because it is not consistent with links other places in Wizdom */


`;

    return component;

});
